% Chudik, Pesaran and Yang (2018)
%
% We use the proposed half-panel jackknife estimator to estimate equation
% (30) of the paper. The estimates are reported in Table 7, columns(1.b), 
% (1.c), (2.b), (2.c), (3.b) and (3.c).
% 
% This empirical application is based on Donohue and Levitt (2001,
% Quarterly Journal of Economics) "The impact of legalized abortion on 
% crime", and Belloni, Chernozhukov and Hansen (2014, Review of Economic
% Studies) "Inference on treatment effects after selection among high-
% -dimensional controls"

clc
clear;

%% Import data 

data = dlmread('CPY_crime_data.dat','\t',1,0);

% Remove DC
state = data(:,1);
ind = (state ~= 9);
data = data(ind,:); 
% Remove Alaska
state = data(:,1);
ind = (state ~= 2);
data = data(ind,:);
% Remove Hawaii
state = data(:,1);
ind = (state ~= 12);
data = data(ind,:);

year   = data(:,2);

% Generate the lags

data1 = data;
data1a = data;
data1b = data;
I = find(year < 85 | year > 96);
Ia = find(year < 85 | year > 90);
Ib = find(year < 91 | year > 96);

data1(I, :) = [];
data1a(Ia, :) = [];
data1b(Ib, :) = [];

lag_y_viol = data1(:,4);
lag_y_prop = data1(:,5);
lag_y_murd = data1(:,6);

lag_y_viola = data1a(:,4);
lag_y_propa = data1a(:,5);
lag_y_murda = data1a(:,6);

lag_y_violb = data1b(:,4);
lag_y_propb = data1b(:,5);
lag_y_murdb = data1b(:,6);

% Remove data for years not used in Levitt analysis
I         = find(year < 86 | year > 97);
year(I,:) = [];
data(I,:) = [];
% year      = year - 84;

pop = log(data(:,3));
weight = sqrt(data(:,3)/sum(data(:,3)));
state  = recode(data(:,1));
y_viol = data(:,4);
y_prop = data(:,5);
y_murd = data(:,6);
xx     = data(:,10:size(data,2));
sdum   = dummyvar(state);
tdum   = dummy(year);
x_viol = data(:,8);
x_prop = data(:,9);
x_murd = data(:,7);

T      = max(year - 84);
N      = max(state);

% Census divisions
% 1. Washington, Alaska, Hawaii, Oregon, California
% 2. Montana, Idaho, Wyoming, Nevada, Utah, Colorado, Arizona, New Mexico
% 3. North Dakota, South Dakota, Nebraska, Kansas, Minnesota, Iowa,
% Missouri
% 4. Oklahoma, Arkansas, Texas, Louisiana
% 5. Wisconsin, Illinois, Michigan, Indiana, Ohio
% 6. New York, Pennsylvania, New Jersey
% 7. Vermont, New Hampshire, Maine, Massachussetts, Connecticut, Rhode
% Island
% 8. Kentucky, Tennessee, Mississippi, Alabama
% 9. West Virginia, DC, Maryland, Delaware, Virginia, North Carolina, South
% Carolina, Georgia, Florida

district = zeros(size(state));
district(state == 1) = 8; district(state == 2) = 2; district(state == 3) = 4;
district(state == 4) = 1; district(state == 5) = 2; district(state == 6) = 7;
district(state == 7) = 9; district(state == 8) = 9; district(state == 9) = 9;
district(state == 10) = 2; district(state == 11) = 5; district(state == 12) = 5;
district(state == 13) = 3; district(state == 14) = 3; district(state == 15) = 8;
district(state == 16) = 4; district(state == 17) = 7; district(state == 18) = 9;
district(state == 19) = 7; district(state == 20) = 5; district(state == 21) = 3;
district(state == 22) = 8; district(state == 23) = 3; district(state == 24) = 2;
district(state == 25) = 3; district(state == 26) = 2; district(state == 27) = 7;
district(state == 28) = 6; district(state == 29) = 2; district(state == 30) = 6;
district(state == 31) = 9; district(state == 32) = 3; district(state == 33) = 5;
district(state == 34) = 4; district(state == 35) = 1; district(state == 36) = 6;
district(state == 37) = 7; district(state == 38) = 9; district(state == 39) = 3;
district(state == 40) = 8; district(state == 41) = 4; district(state == 42) = 2;
district(state == 43) = 7; district(state == 44) = 9; district(state == 45) = 1;
district(state == 46) = 9; district(state == 47) = 5; district(state == 48) = 2;

% clear data I;

%% Estimate linear models in levels with FE, time effects and control variables

Dummies = [dummyvar(recode(state)) dummyvar(recode(year))];
MDummies = Dummies * pinv(Dummies' * Dummies);

AllXv = [x_viol, xx, lag_y_viol] - MDummies * Dummies' * [x_viol, xx, lag_y_viol];
Allyv = y_viol - MDummies * Dummies' * y_viol;
AllXp = [x_prop, xx, lag_y_prop] - MDummies * Dummies' * [x_prop, xx, lag_y_prop];
Allyp = y_prop - MDummies * Dummies' * y_prop;
AllXm = [x_murd, xx, lag_y_murd] - MDummies * Dummies' * [x_murd, xx, lag_y_murd];
Allym = y_murd - MDummies * Dummies' * y_murd;

% Estimate regression coefficients and residuals

Betav = (AllXv' * AllXv)^(-1) * AllXv' * Allyv;
Betap = (AllXp' * AllXp)^(-1) * AllXp' * Allyp;
Betam = (AllXm' * AllXm)^(-1) * AllXm' * Allym;

Resv = Allyv - AllXv * Betav;
Resp = Allyp - AllXp * Betap;
Resm = Allym - AllXm * Betam;

K = size(AllXv, 2);

MxMuv = AllXv;
MxMup = AllXp;
MxMum = AllXm;

for k = 1:K
    
    MxMuv(:, k) = AllXv(:, k) .* Resv;
    MxMup(:, k) = AllXp(:, k) .* Resp;
    MxMum(:, k) = AllXm(:, k) .* Resm;
    
end

Varv = (AllXv' * AllXv)^(-1) * (MxMuv' * MxMuv) * (AllXv' * AllXv)^(-1);
Varp = (AllXp' * AllXp)^(-1) * (MxMup' * MxMup) * (AllXp' * AllXp)^(-1);
Varm = (AllXm' * AllXm)^(-1) * (MxMum' * MxMum) * (AllXm' * AllXm)^(-1);

Stdv = sqrt(diag(Varv));
Stdp = sqrt(diag(Varp));
Stdm = sqrt(diag(Varm));

Betav(7, :) = Betav(7, :) * 1000;
Betap(7, :) = Betap(7, :) * 1000;
Betam(7, :) = Betam(7, :) * 1000;
Stdv(7, :) = Stdv(7, :) * 1000;
Stdp(7, :) = Stdp(7, :) * 1000;
Stdm(7, :) = Stdm(7, :) * 1000;

% Display results
disp('Violence')
disp([Betav Stdv Betav./Stdv])
disp(' ')
disp('Property')
disp([Betap Stdp Betap./Stdp])
disp(' ')
disp('Murder')
disp([Betam Stdm Betam./Stdm])
disp(' ')

Betav(7, :) = Betav(7, :) / 1000;
Betap(7, :) = Betap(7, :) / 1000;
Betam(7, :) = Betam(7, :) / 1000;
Stdv(7, :) = Stdv(7, :) / 1000;
Stdp(7, :) = Stdp(7, :) / 1000;
Stdm(7, :) = Stdm(7, :) / 1000;

% Long-run

LongBetav = Betav(1:9) / (1 - Betav(10));
LongBetap = Betap(1:9) / (1 - Betap(10));
LongBetam = Betam(1:9) / (1 - Betam(10));
LongVarv = zeros(9, 1);
LongVarp = zeros(9, 1);
LongVarm = zeros(9, 1);
for i = 1:9
    LongVarv(i) = [1 / (1 - Betav(10)), Betav(i) / ((1 - Betav(10))^2)]...
        * [Varv(i, i), Varv(i, 10); Varv(10, i), Varv(10, 10)]...
        * [1 / (1 - Betav(10)); Betav(i) / ((1 - Betav(10))^2)];
    LongVarp(i) = [1 / (1 - Betap(10)), Betap(i) / ((1 - Betap(10))^2)]...
        * [Varp(i, i), Varp(i, 10); Varp(10, i), Varp(10, 10)]...
        * [1 / (1 - Betap(10)); Betap(i) / ((1 - Betap(10))^2)];
    LongVarm(i) = [1 / (1 - Betam(10)), Betam(i) / ((1 - Betam(10))^2)]...
        * [Varm(i, i), Varm(i, 10); Varm(10, i), Varm(10, 10)]...
        * [1 / (1 - Betam(10)); Betam(i) / ((1 - Betam(10))^2)];
end

LongStdv = sqrt(LongVarv);
LongStdp = sqrt(LongVarp);
LongStdm = sqrt(LongVarm);

LongBetav(7, :) = LongBetav(7, :) * 1000;
LongBetap(7, :) = LongBetap(7, :) * 1000;
LongBetam(7, :) = LongBetam(7, :) * 1000;
LongStdv(7, :) = LongStdv(7, :) * 1000;
LongStdp(7, :) = LongStdp(7, :) * 1000;
LongStdm(7, :) = LongStdm(7, :) * 1000;

% Display results
disp('Violence - Long-run')
disp([LongBetav LongStdv LongBetav./LongStdv])
disp(' ')
disp('Property - Long-run')
disp([LongBetap LongStdp LongBetap./LongStdp])
disp(' ')
disp('Murder - Long-run')
disp([LongBetam LongStdm LongBetam./LongStdm])
disp(' ')

LongBetav(7, :) = LongBetav(7, :) / 1000;
LongBetap(7, :) = LongBetap(7, :) / 1000;
LongBetam(7, :) = LongBetam(7, :) / 1000;
LongStdv(7, :) = LongStdv(7, :) / 1000;
LongStdp(7, :) = LongStdp(7, :) / 1000;
LongStdm(7, :) = LongStdm(7, :) / 1000;

%% Estimate linear models in levels with FE, time effects and control variables -- Jackknife

yearab = year;
yeara = year;
yearb = year;

dataab = data;
dataa = data;
datab = data;

Iab           = find(yearab < 86 | yearab > 97);
yearab(Iab,:) = [];
dataab(Iab,:) = [];

Ia          = find(yeara < 86 | yeara > 91);
yeara(Ia,:) = [];
dataa(Ia,:) = [];

Ib          = find(yearb < 92 | yearb > 97);
yearb(Ib,:) = [];
datab(Ib,:) = [];

stateab  = recode(dataab(:,1));
y_violab = dataab(:,4);
y_propab = dataab(:,5);
y_murdab = dataab(:,6);
xxab     = dataab(:,10:size(dataab,2));
x_violab = dataab(:,8);
x_propab = dataab(:,9);
x_murdab = dataab(:,7);

statea  = recode(dataa(:,1));
y_viola = dataa(:,4);
y_propa = dataa(:,5);
y_murda = dataa(:,6);
xxa     = dataa(:,10:size(dataa,2));
x_viola = dataa(:,8);
x_propa = dataa(:,9);
x_murda = dataa(:,7);

stateb  = recode(datab(:,1));
y_violb = datab(:,4);
y_propb = datab(:,5);
y_murdb = datab(:,6);
xxb     = datab(:,10:size(datab,2));
x_violb = datab(:,8);
x_propb = datab(:,9);
x_murdb = datab(:,7);

Dummiesab = [dummyvar(recode(stateab)) dummyvar(recode(yearab))];
MDummiesab = Dummiesab * pinv(Dummiesab' * Dummiesab);

Dummiesa = [dummyvar(recode(statea)) dummyvar(recode(yeara))];
MDummiesa = Dummiesa * pinv(Dummiesa' * Dummiesa);

Dummiesb = [dummyvar(recode(stateb)) dummyvar(recode(yearb))];
MDummiesb = Dummiesb * pinv(Dummiesb' * Dummiesb);

AllXvab = [x_violab, xxab, lag_y_viol] - MDummiesab * Dummiesab' * [x_violab, xxab, lag_y_viol];
Allyvab = y_violab - MDummiesab * Dummiesab' * y_violab;
AllXpab = [x_propab, xxab, lag_y_prop] - MDummiesab * Dummiesab' * [x_propab, xxab, lag_y_prop];
Allypab = y_propab - MDummiesab * Dummiesab' * y_propab;
AllXmab = [x_murdab, xxab, lag_y_murd] - MDummiesab * Dummiesab' * [x_murdab, xxab, lag_y_murd];
Allymab = y_murdab - MDummiesab * Dummiesab' * y_murdab;

AllXva = [x_viola, xxa, lag_y_viola] - MDummiesa * Dummiesa' * [x_viola, xxa, lag_y_viola];
Allyva = y_viola - MDummiesa * Dummiesa' * y_viola;
AllXpa = [x_propa, xxa, lag_y_propa] - MDummiesa * Dummiesa' * [x_propa, xxa, lag_y_propa];
Allypa = y_propa - MDummiesa * Dummiesa' * y_propa;
AllXma = [x_murda, xxa, lag_y_murda] - MDummiesa * Dummiesa' * [x_murda, xxa, lag_y_murda];
Allyma = y_murda - MDummiesa * Dummiesa' * y_murda;

AllXvb = [x_violb, xxb, lag_y_violb] - MDummiesb * Dummiesb' * [x_violb, xxb, lag_y_violb];
Allyvb = y_violb - MDummiesb * Dummiesb' * y_violb;
AllXpb = [x_propb, xxb, lag_y_propb] - MDummiesb * Dummiesb' * [x_propb, xxb, lag_y_propb];
Allypb = y_propb - MDummiesb * Dummiesb' * y_propb;
AllXmb = [x_murdb, xxb, lag_y_murdb] - MDummiesb * Dummiesb' * [x_murdb, xxb, lag_y_murdb];
Allymb = y_murdb - MDummiesb * Dummiesb' * y_murdb;

Betavab = (AllXvab' * AllXvab)^(-1) * AllXvab' * Allyvab;
Betapab = (AllXpab' * AllXpab)^(-1) * AllXpab' * Allypab;
Betamab = (AllXmab' * AllXmab)^(-1) * AllXmab' * Allymab;

Betava = (AllXva' * AllXva)^(-1) * AllXva' * Allyva;
Betapa = (AllXpa' * AllXpa)^(-1) * AllXpa' * Allypa;
Betama = (AllXma' * AllXma)^(-1) * AllXma' * Allyma;

Betavb = (AllXvb' * AllXvb)^(-1) * AllXvb' * Allyvb;
Betapb = (AllXpb' * AllXpb)^(-1) * AllXpb' * Allypb;
Betamb = (AllXmb' * AllXmb)^(-1) * AllXmb' * Allymb;

BetavJ = 2 * Betavab - 0.5 * Betava - 0.5 * Betavb;
BetapJ = 2 * Betapab - 0.5 * Betapa - 0.5 * Betapb;
BetamJ = 2 * Betamab - 0.5 * Betama - 0.5 * Betamb;

AllXvavb = [AllXva(1:6, :); AllXvb(1:6, :)];
AllXpavb = [AllXpa(1:6, :); AllXpb(1:6, :)];
AllXmavb = [AllXma(1:6, :); AllXmb(1:6, :)];

begina = 7;
beginb = 7;

for i = 2:48
    
    enda = begina + 5;
    endb = beginb + 5;
    
    AllXvavb = [AllXvavb; AllXva(begina:enda, :); AllXvb(beginb:endb, :)];
    AllXpavb = [AllXpavb; AllXpa(begina:enda, :); AllXpb(beginb:endb, :)];
    AllXmavb = [AllXmavb; AllXma(begina:enda, :); AllXmb(beginb:endb, :)];
    
    begina = enda + 1;
    beginb = endb + 1;
    
end

ResvJ = Allyvab - AllXvab * BetavJ;
RespJ = Allypab - AllXpab * BetapJ;
ResmJ = Allymab - AllXmab * BetamJ;

dv = 2 * AllXvab - AllXvavb;
dp = 2 * AllXpab - AllXpavb;
dm = 2 * AllXmab - AllXmavb;

dMuJv = dv;
dMuJp = dp;
dMuJm = dm;

for k = 1:K
    
    dMuJv(:, k) = dv(:, k) .* ResvJ;
    dMuJp(:, k) = dp(:, k) .* RespJ;
    dMuJm(:, k) = dm(:, k) .* ResmJ;
    
end

VarvJ = (AllXvab' * AllXvab)^(-1) * (dMuJv' * dMuJv) * (AllXvab' * AllXvab)^(-1);
VarpJ = (AllXpab' * AllXpab)^(-1) * (dMuJp' * dMuJp) * (AllXpab' * AllXpab)^(-1);
VarmJ = (AllXmab' * AllXmab)^(-1) * (dMuJm' * dMuJm) * (AllXmab' * AllXmab)^(-1);

StdvJ = sqrt(diag(VarvJ));
StdpJ = sqrt(diag(VarpJ));
StdmJ = sqrt(diag(VarmJ));

BetavJ(7, :) = BetavJ(7, :) * 1000;
BetapJ(7, :) = BetapJ(7, :) * 1000;
BetamJ(7, :) = BetamJ(7, :) * 1000;
StdvJ(7, :) = StdvJ(7, :) * 1000;
StdpJ(7, :) = StdpJ(7, :) * 1000;
StdmJ(7, :) = StdmJ(7, :) * 1000;

% Display results
disp('Violence Jackknife')
disp([BetavJ StdvJ BetavJ./StdvJ])
disp(' ')
disp('Property Jackknife')
disp([BetapJ StdpJ BetapJ./StdpJ])
disp(' ')
disp('Murder Jackknife')
disp([BetamJ StdmJ BetamJ./StdmJ])
disp(' ')

BetavJ(7, :) = BetavJ(7, :) / 1000;
BetapJ(7, :) = BetapJ(7, :) / 1000;
BetamJ(7, :) = BetamJ(7, :) / 1000;
StdvJ(7, :) = StdvJ(7, :) / 1000;
StdpJ(7, :) = StdpJ(7, :) / 1000;
StdmJ(7, :) = StdmJ(7, :) / 1000;

% Long-run

LongBetavJ = BetavJ(1:9) / (1 - BetavJ(10));
LongBetapJ = BetapJ(1:9) / (1 - BetapJ(10));
LongBetamJ = BetamJ(1:9) / (1 - BetamJ(10));
LongVarvJ = zeros(9, 1);
LongVarpJ = zeros(9, 1);
LongVarmJ = zeros(9, 1);
for i = 1:9
    LongVarvJ(i) = [1 / (1 - BetavJ(10)), BetavJ(i) / ((1 - BetavJ(10))^2)]...
        * [VarvJ(i, i), VarvJ(i, 10); VarvJ(10, i), VarvJ(10, 10)]...
        * [1 / (1 - BetavJ(10)); BetavJ(i) / ((1 - BetavJ(10))^2)];
    LongVarpJ(i) = [1 / (1 - BetapJ(10)), BetapJ(i) / ((1 - BetapJ(10))^2)]...
        * [VarpJ(i, i), VarpJ(i, 10); VarpJ(10, i), VarpJ(10, 10)]...
        * [1 / (1 - BetapJ(10)); BetapJ(i) / ((1 - BetapJ(10))^2)];
    LongVarmJ(i) = [1 / (1 - BetamJ(10)), BetamJ(i) / ((1 - BetamJ(10))^2)]...
        * [VarmJ(i, i), VarmJ(i, 10); VarmJ(10, i), VarmJ(10, 10)]...
        * [1 / (1 - BetamJ(10)); BetamJ(i) / ((1 - BetamJ(10))^2)];
end

LongStdvJ = sqrt(LongVarvJ);
LongStdpJ = sqrt(LongVarpJ);
LongStdmJ = sqrt(LongVarmJ);

LongBetavJ(7, :) = LongBetavJ(7, :) * 1000;
LongBetapJ(7, :) = LongBetapJ(7, :) * 1000;
LongBetamJ(7, :) = LongBetamJ(7, :) * 1000;
LongStdvJ(7, :) = LongStdvJ(7, :) * 1000;
LongStdpJ(7, :) = LongStdpJ(7, :) * 1000;
LongStdmJ(7, :) = LongStdmJ(7, :) * 1000;

% Display results
disp('Violence - Long-run')
disp([LongBetavJ LongStdvJ LongBetavJ./LongStdvJ])
disp(' ')
disp('Property - Long-run')
disp([LongBetapJ LongStdpJ LongBetapJ./LongStdpJ])
disp(' ')
disp('Murder - Long-run')
disp([LongBetamJ LongStdmJ LongBetamJ./LongStdmJ])
disp(' ')

LongBetavJ(7, :) = LongBetavJ(7, :) / 1000;
LongBetapJ(7, :) = LongBetapJ(7, :) / 1000;
LongBetamJ(7, :) = LongBetamJ(7, :) / 1000;
LongStdvJ(7, :) = LongStdvJ(7, :) / 1000;
LongStdpJ(7, :) = LongStdpJ(7, :) / 1000;
LongStdmJ(7, :) = LongStdmJ(7, :) / 1000;
